// By EVOLVED
// www.evolved-software.com

//--------------
// tweaks
//--------------  
   float Offset=4;
   float2 ViewSize;
   float3 LightDirection;
   float2 DofMultiplier={2,5};
   float DofMinRange=100000;
   float COCSize=4.0;
   float4 SamplesOffset[18]={float4(2,0,0,0),
	                     float4(1,0,0,0),
	                     float4(-1,0,0,0),
	                     float4(-2,0,0,0),	    
	                     float4(1.5,0.875,0,0),
	                     float4(0.5,0.875,0,0),
	                     float4(-0.5,0.875,0,0),
	                     float4(-1.5,0.875,0,0),		     
	                     float4(1.5,-0.875,0,0),
	                     float4(0.5,-0.875,0,0),
	                     float4(-0.5,-0.875,0,0),
	                     float4(-1.5,-0.875,0,0),		     
	                     float4(1,1.75,0,0),
	                     float4(0,1.75,0,0),
	                     float4(-1,1.75,0,0),
	                     float4(1,-1.75,0,0),
	                     float4(0,-1.75,0,0),
	                     float4(-1,-1.75,0,0)};

//--------------
// Textures
//--------------
   texture RenderTexture <string Name = " ";>;
   sampler RenderSampler=sampler_state 
      {
	Texture=<RenderTexture>;
     	ADDRESSU=Clamp;
        ADDRESSV=Clamp;
      };
   texture DepthTexture <string Name = " ";>;
   sampler DepthSampler=sampler_state 
      {
	Texture=<DepthTexture>;
     	ADDRESSU=Clamp;
        ADDRESSV=Clamp;
	MipFilter=None;
	MagFilter=None;
	MinFilter=None;
      };
   texture AdaptedLumTexture <string Name = " ";>;
   sampler AdaptedLumSampler=sampler_state 
      {
	Texture=<AdaptedLumTexture>;
     	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
	MagFilter=None;
	MinFilter=None;
	MipFilter=None;
      };

//--------------
// structs 
//--------------
   struct InPut
     {
 	float4 Pos:POSITION;
     };
   struct OutPut
     {
	float4 Pos:POSITION; 
	float4 Tex:TEXCOORD0;
	float4 Tex1:TEXCOORD1;
	float4 Tex2:TEXCOORD2;
	float4 Tex3:TEXCOORD3;
	float4 Tex4:TEXCOORD4;
     };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN) 
     {
 	OutPut OUT;
	OUT.Pos=IN.Pos; 
 	OUT.Tex.xy=((float2(IN.Pos.x,-IN.Pos.y)+1.0)*0.5)+ViewSize;
 	OUT.Tex.zw=0.0;
 	OUT.Tex1.xy=OUT.Tex.xy+float2(ViewSize.x,ViewSize.y)*Offset;
 	OUT.Tex1.zw=OUT.Tex.xy+float2(0,ViewSize.y)*Offset;
 	OUT.Tex2.xy=OUT.Tex.xy+float2(-ViewSize.x,ViewSize.y)*Offset;
 	OUT.Tex2.zw=OUT.Tex.xy+float2(ViewSize.x,0)*Offset;
 	OUT.Tex3.xy=OUT.Tex.xy+float2(-ViewSize.x,0)*Offset;
 	OUT.Tex3.zw=OUT.Tex.xy+float2(ViewSize.x,-ViewSize.y)*Offset;
 	OUT.Tex4.xy=OUT.Tex.xy+float2(0,-ViewSize.y)*Offset;
 	OUT.Tex4.zw=OUT.Tex.xy+float2(-ViewSize.x,-ViewSize.y)*Offset;
	return OUT;
    }

//--------------
// pixel shader
//--------------
  float4 PS(OutPut IN) : COLOR
     {
	float4 FrameRender=tex2Dlod(RenderSampler,IN.Tex);
	float MbMask=FrameRender.w;
	float2 AutoFocus=min(tex1Dlod(AdaptedLumSampler,0).yy,DofMinRange)*DofMultiplier;
	FrameRender.w=((1/tex2Dlod(DepthSampler,IN.Tex).x)-AutoFocus.x)/AutoFocus.y;
	FrameRender.w=1-saturate(exp(-FrameRender.w*16));
	float4 COCRad=float4(ViewSize*COCSize*FrameRender.w,0,0);
	float4 DofCOC=float4(FrameRender.xyz,1);
	for (int i = 0; i < 18; i++) {
	 float4 TexTap=IN.Tex+SamplesOffset[i]*COCRad;
	 float3 FrameTap=tex2Dlod(RenderSampler,TexTap);
	 float FocusTap=((1/tex2Dlod(DepthSampler,TexTap).x)-AutoFocus.x)/AutoFocus.y;
 	 FocusTap=1-saturate(exp(-FocusTap*16));
	 DofCOC +=float4(FrameTap*FocusTap,FocusTap);
	}
	FrameRender.xyz=DofCOC.xyz/DofCOC.w;
	return float4(FrameRender.xyz,MbMask);
     }

//--------------
// techniques   
//--------------
    technique Downfilter
      {
 	pass p1
      {	
 	VertexShader = compile vs_3_0 VS();
 	PixelShader  = compile ps_3_0 PS();
	zwriteenable=false;
	zenable=false;
	ZFunc=always;
      }
      }
